(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     65059,       1460]
NotebookOptionsPosition[     64020,       1434]
NotebookOutlinePosition[     64416,       1450]
CellTagsIndexPosition[     64373,       1447]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "\n", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Step", " ", "1"}], ":", 
    RowBox[{
    "Solve", " ", "the", " ", "original", " ", "equation", " ", "for", " ", 
     "dD"}]}], "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"dDSol", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Sigma]", ">", "0"}], "&&", 
     RowBox[{"l", ">", "0"}], "&&", 
     RowBox[{"d", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}]}], ",", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"\[CapitalDelta]G", "==", 
       RowBox[{"\[Sigma]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", "*", 
              RowBox[{"l", "/", 
               RowBox[{"(", 
                RowBox[{"\[Pi]", "*", 
                 RowBox[{"d", "^", "2"}]}], ")"}]}]}], "+", 
             RowBox[{"1", "/", "d"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", "*", 
              RowBox[{"l", "/", 
               RowBox[{"(", 
                RowBox[{"\[Pi]", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"d", "^", "2"}], "-", 
                   RowBox[{"dD", "^", "2"}]}], ")"}]}], ")"}]}]}], "+", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"d", "^", "2"}], "-", 
                RowBox[{"dD", "^", "2"}]}], "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]}]}], ")"}]}]}], ",", "dD", ",", 
      "Reals"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9230121981681757`*^9, 3.923012266815718*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"828ac962-c356-4a6c-a4ce-ae15297319ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dD", "\[Rule]", 
     TemplateBox[{
       RowBox[{"-", 
         RowBox[{"\[Sqrt]", 
           RowBox[{"(", 
             RowBox[{
               RowBox[{
                 FractionBox["1", 
                  RowBox[{"2", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4", " ", "l"}], "+", 
                    RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}]], 
                 RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                    RowBox[{"8", " ", "d", " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                    RowBox[{
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
                    RowBox[{"128", " ", 
                    SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", 
                    "\[Sigma]"}], "+", 
                    RowBox[{"64", " ", "d", " ", 
                    SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                    "\[CapitalDelta]G", " ", "\[Sigma]"}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["d", "2"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", 
                    " ", "\[Sigma]"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["d", "3"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", 
                    " ", "\[Sigma]"}], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["d", "3"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "-", 
               RowBox[{
                 FractionBox["1", 
                  RowBox[{"2", " ", 
                    SqrtBox["\[Pi]"], " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4", " ", "l"}], "+", 
                    RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}]], 
                 RowBox[{"(", 
                   RowBox[{"\[Sqrt]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"256", " ", 
                    SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{"256", " ", "d", " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{"96", " ", 
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["d", "3"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "-", 
                    RowBox[{"4096", " ", 
                    SuperscriptBox["l", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"4096", " ", "d", " ", 
                    SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"1792", " ", 
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"448", " ", 
                    SuperscriptBox["d", "3"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["d", "4"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["d", "5"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "+", 
                    RowBox[{"3072", " ", 
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"2304", " ", 
                    SuperscriptBox["d", "3"], " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"672", " ", 
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"96", " ", 
                    SuperscriptBox["d", "5"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["d", "6"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "-", 
                    RowBox[{"768", " ", 
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "-", 
                    RowBox[{"384", " ", 
                    SuperscriptBox["d", "5"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "-", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["d", "6"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["d", "7"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "+", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["d", "6"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[Sigma]", "4"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["d", "7"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[Sigma]", "4"]}], "+", 
                    RowBox[{
                    SuperscriptBox["d", "8"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[Sigma]", "4"]}]}], ")"}]}], ")"}]}]}], 
             ")"}]}]}], 
       RowBox[{
         RowBox[{"\[CapitalDelta]G", ">", "0"}], "&&", 
         RowBox[{"\[Sigma]", ">", 
           FractionBox[
            RowBox[{
              RowBox[{"4", " ", "l", " ", "\[CapitalDelta]G"}], "+", 
              RowBox[{"d", " ", "\[Pi]", " ", "\[CapitalDelta]G"}]}], 
            RowBox[{
              SuperscriptBox["d", "2"], " ", "\[Pi]"}]]}]}]},
      "ConditionalExpression"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"dD", "\[Rule]", 
     TemplateBox[{
       RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
           RowBox[{
             RowBox[{
               FractionBox["1", 
                RowBox[{"2", " ", "\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4", " ", "l"}], "+", 
                    RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                  SuperscriptBox["\[Sigma]", "2"]}]], 
               RowBox[{"(", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                   RowBox[{"8", " ", "d", " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                   RowBox[{
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
                   RowBox[{"128", " ", 
                    SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", 
                    "\[Sigma]"}], "+", 
                   RowBox[{"64", " ", "d", " ", 
                    SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                    "\[CapitalDelta]G", " ", "\[Sigma]"}], "+", 
                   RowBox[{"16", " ", 
                    SuperscriptBox["d", "2"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", 
                    " ", "\[Sigma]"}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["d", "3"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", 
                    " ", "\[Sigma]"}], "+", 
                   RowBox[{"8", " ", 
                    SuperscriptBox["d", "3"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                   RowBox[{
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "-", 
             RowBox[{
               FractionBox["1", 
                RowBox[{"2", " ", 
                  SqrtBox["\[Pi]"], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"4", " ", "l"}], "+", 
                    RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                  SuperscriptBox["\[Sigma]", "2"]}]], 
               RowBox[{"(", 
                 RowBox[{"\[Sqrt]", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"256", " ", 
                    SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{"256", " ", "d", " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{"96", " ", 
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["d", "3"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                    RowBox[{
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "4"]}], "-", 
                    RowBox[{"4096", " ", 
                    SuperscriptBox["l", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"4096", " ", "d", " ", 
                    SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"1792", " ", 
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"448", " ", 
                    SuperscriptBox["d", "3"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["d", "4"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["d", "5"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "3"], " ", 
                    "\[Sigma]"}], "+", 
                    RowBox[{"3072", " ", 
                    SuperscriptBox["d", "2"], " ", 
                    SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"2304", " ", 
                    SuperscriptBox["d", "3"], " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"672", " ", 
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"96", " ", 
                    SuperscriptBox["d", "5"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["d", "6"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "-", 
                    RowBox[{"768", " ", 
                    SuperscriptBox["d", "4"], " ", 
                    SuperscriptBox["l", "3"], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "-", 
                    RowBox[{"384", " ", 
                    SuperscriptBox["d", "5"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "-", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["d", "6"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["d", "7"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", "\[CapitalDelta]G", 
                    " ", 
                    SuperscriptBox["\[Sigma]", "3"]}], "+", 
                    RowBox[{"64", " ", 
                    SuperscriptBox["d", "6"], " ", 
                    SuperscriptBox["l", "2"], " ", 
                    SuperscriptBox["\[Pi]", "3"], " ", 
                    SuperscriptBox["\[Sigma]", "4"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["d", "7"], " ", "l", " ", 
                    SuperscriptBox["\[Pi]", "4"], " ", 
                    SuperscriptBox["\[Sigma]", "4"]}], "+", 
                    RowBox[{
                    SuperscriptBox["d", "8"], " ", 
                    SuperscriptBox["\[Pi]", "5"], " ", 
                    SuperscriptBox["\[Sigma]", "4"]}]}], ")"}]}], ")"}]}]}], 
           ")"}]}], 
       RowBox[{
         RowBox[{"\[CapitalDelta]G", ">", "0"}], "&&", 
         RowBox[{"\[Sigma]", ">", 
           FractionBox[
            RowBox[{
              RowBox[{"4", " ", "l", " ", "\[CapitalDelta]G"}], "+", 
              RowBox[{"d", " ", "\[Pi]", " ", "\[CapitalDelta]G"}]}], 
            RowBox[{
              SuperscriptBox["d", "2"], " ", "\[Pi]"}]]}]}]},
      "ConditionalExpression"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.92301231320148*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"20ee5218-4a7a-4301-94bd-6e9e9982248d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"As", " ", "there", " ", "are", " ", "two", " ", "results"}], ",",
     " ", 
    RowBox[{
    "we", " ", "should", " ", "consider", " ", "the", " ", "second", " ", 
     "one", " ", "as", " ", "first", " ", "gives", " ", "us", " ", "negative",
      " ", 
     RowBox[{"results", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dD", " ", "=", " ", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "l"}], "+", 
             RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "16"}], " ", 
           SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
           SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
          RowBox[{"8", " ", "d", " ", "l", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
          RowBox[{
           SuperscriptBox["d", "2"], " ", 
           SuperscriptBox["\[Pi]", "3"], " ", 
           SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", 
           "\[Sigma]"}], "+", 
          RowBox[{"64", " ", "d", " ", 
           SuperscriptBox["l", "2"], " ", "\[Pi]", " ", "\[CapitalDelta]G", 
           " ", "\[Sigma]"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["d", "2"], " ", "l", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
           "\[Sigma]"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["d", "3"], " ", 
           SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
           "\[Sigma]"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["d", "3"], " ", "l", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["\[Sigma]", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["d", "4"], " ", 
           SuperscriptBox["\[Pi]", "3"], " ", 
           SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          SqrtBox["\[Pi]"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "l"}], "+", 
             RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}]], 
        RowBox[{"(", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"256", " ", 
             SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
             SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
            RowBox[{"256", " ", "d", " ", 
             SuperscriptBox["l", "3"], " ", 
             SuperscriptBox["\[Pi]", "2"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["d", "2"], " ", 
             SuperscriptBox["l", "2"], " ", 
             SuperscriptBox["\[Pi]", "3"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["d", "3"], " ", "l", " ", 
             SuperscriptBox["\[Pi]", "4"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["d", "4"], " ", 
             SuperscriptBox["\[Pi]", "5"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "4"]}], "-", 
            RowBox[{"4096", " ", 
             SuperscriptBox["l", "5"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
            
            RowBox[{"4096", " ", "d", " ", 
             SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
             SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
            
            RowBox[{"1792", " ", 
             SuperscriptBox["d", "2"], " ", 
             SuperscriptBox["l", "3"], " ", 
             SuperscriptBox["\[Pi]", "2"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
            
            RowBox[{"448", " ", 
             SuperscriptBox["d", "3"], " ", 
             SuperscriptBox["l", "2"], " ", 
             SuperscriptBox["\[Pi]", "3"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
            
            RowBox[{"64", " ", 
             SuperscriptBox["d", "4"], " ", "l", " ", 
             SuperscriptBox["\[Pi]", "4"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
            
            RowBox[{"4", " ", 
             SuperscriptBox["d", "5"], " ", 
             SuperscriptBox["\[Pi]", "5"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "+", 
            
            RowBox[{"3072", " ", 
             SuperscriptBox["d", "2"], " ", 
             SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
             SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
             SuperscriptBox["\[Sigma]", "2"]}], "+", 
            RowBox[{"2304", " ", 
             SuperscriptBox["d", "3"], " ", 
             SuperscriptBox["l", "3"], " ", 
             SuperscriptBox["\[Pi]", "2"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
             SuperscriptBox["\[Sigma]", "2"]}], "+", 
            RowBox[{"672", " ", 
             SuperscriptBox["d", "4"], " ", 
             SuperscriptBox["l", "2"], " ", 
             SuperscriptBox["\[Pi]", "3"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
             SuperscriptBox["\[Sigma]", "2"]}], "+", 
            RowBox[{"96", " ", 
             SuperscriptBox["d", "5"], " ", "l", " ", 
             SuperscriptBox["\[Pi]", "4"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
             SuperscriptBox["\[Sigma]", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["d", "6"], " ", 
             SuperscriptBox["\[Pi]", "5"], " ", 
             SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
             SuperscriptBox["\[Sigma]", "2"]}], "-", 
            RowBox[{"768", " ", 
             SuperscriptBox["d", "4"], " ", 
             SuperscriptBox["l", "3"], " ", 
             SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
             SuperscriptBox["\[Sigma]", "3"]}], "-", 
            RowBox[{"384", " ", 
             SuperscriptBox["d", "5"], " ", 
             SuperscriptBox["l", "2"], " ", 
             SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
             SuperscriptBox["\[Sigma]", "3"]}], "-", 
            RowBox[{"64", " ", 
             SuperscriptBox["d", "6"], " ", "l", " ", 
             SuperscriptBox["\[Pi]", "4"], " ", "\[CapitalDelta]G", " ", 
             SuperscriptBox["\[Sigma]", "3"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["d", "7"], " ", 
             SuperscriptBox["\[Pi]", "5"], " ", "\[CapitalDelta]G", " ", 
             SuperscriptBox["\[Sigma]", "3"]}], "+", 
            RowBox[{"64", " ", 
             SuperscriptBox["d", "6"], " ", 
             SuperscriptBox["l", "2"], " ", 
             SuperscriptBox["\[Pi]", "3"], " ", 
             SuperscriptBox["\[Sigma]", "4"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["d", "7"], " ", "l", " ", 
             SuperscriptBox["\[Pi]", "4"], " ", 
             SuperscriptBox["\[Sigma]", "4"]}], "+", 
            RowBox[{
             SuperscriptBox["d", "8"], " ", 
             SuperscriptBox["\[Pi]", "5"], " ", 
             SuperscriptBox["\[Sigma]", "4"]}]}], ")"}]}], ")"}]}]}], 
      ")"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Following", " ", "equation", " ", "is", " ", "valid", " ", "when", " ", 
      "we", " ", "have", " ", "an", " ", "increase", " ", "or", " ", 
      "decrease", " ", "in", " ", "pore", " ", "size", " ", "leading", " ", 
      "to", " ", "new", " ", "pore", " ", "size", " ", "d1", " ", "and", " ", 
      "new", " ", "dG"}], " ", "->", " ", "dG1"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"newEq", "=", 
    RowBox[{"\[CapitalDelta]G1", "==", 
     RowBox[{"\[Sigma]", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", 
            RowBox[{"l", "/", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "*", 
               RowBox[{"d1", "^", "2"}]}], ")"}]}]}], "+", 
           RowBox[{"1", "/", "d1"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "*", 
            RowBox[{"l", "/", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"d1", "^", "2"}], "-", 
                 RowBox[{"dD", "^", "2"}]}], ")"}]}], ")"}]}]}], "+", 
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{
              RowBox[{"d1", "^", "2"}], "-", 
              RowBox[{"dD", "^", "2"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], ")"}]}]}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9230123173608007`*^9, 3.9230124400004587`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"e958bfd6-1af1-4d74-a9e9-06545e84d108"],

Cell[BoxData[
 RowBox[{"\[Sqrt]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "l"}], "+", 
          RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
       SuperscriptBox["\[Sigma]", "2"]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
        SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
       RowBox[{"8", " ", "d", " ", "l", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
       RowBox[{
        SuperscriptBox["d", "2"], " ", 
        SuperscriptBox["\[Pi]", "3"], " ", 
        SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
       RowBox[{"128", " ", 
        SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", "\[Sigma]"}], 
       "+", 
       RowBox[{"64", " ", "d", " ", 
        SuperscriptBox["l", "2"], " ", "\[Pi]", " ", "\[CapitalDelta]G", " ", 
        "\[Sigma]"}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["d", "2"], " ", "l", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
        "\[Sigma]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["d", "3"], " ", 
        SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
        "\[Sigma]"}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["d", "3"], " ", "l", " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["\[Sigma]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["d", "4"], " ", 
        SuperscriptBox["\[Pi]", "3"], " ", 
        SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "l"}], "+", 
          RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
       SuperscriptBox["\[Sigma]", "2"]}]], 
     RowBox[{"(", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"256", " ", 
          SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
          SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
         RowBox[{"256", " ", "d", " ", 
          SuperscriptBox["l", "3"], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
         RowBox[{"96", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["l", "2"], " ", 
          SuperscriptBox["\[Pi]", "3"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["d", "3"], " ", "l", " ", 
          SuperscriptBox["\[Pi]", "4"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["d", "4"], " ", 
          SuperscriptBox["\[Pi]", "5"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "4"]}], "-", 
         RowBox[{"4096", " ", 
          SuperscriptBox["l", "5"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
         RowBox[{"4096", " ", "d", " ", 
          SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
          SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
         RowBox[{"1792", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["l", "3"], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
         RowBox[{"448", " ", 
          SuperscriptBox["d", "3"], " ", 
          SuperscriptBox["l", "2"], " ", 
          SuperscriptBox["\[Pi]", "3"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["d", "4"], " ", "l", " ", 
          SuperscriptBox["\[Pi]", "4"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "5"], " ", 
          SuperscriptBox["\[Pi]", "5"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}], "+", 
         RowBox[{"3072", " ", 
          SuperscriptBox["d", "2"], " ", 
          SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
          SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "+", 
         RowBox[{"2304", " ", 
          SuperscriptBox["d", "3"], " ", 
          SuperscriptBox["l", "3"], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "+", 
         RowBox[{"672", " ", 
          SuperscriptBox["d", "4"], " ", 
          SuperscriptBox["l", "2"], " ", 
          SuperscriptBox["\[Pi]", "3"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "+", 
         RowBox[{"96", " ", 
          SuperscriptBox["d", "5"], " ", "l", " ", 
          SuperscriptBox["\[Pi]", "4"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["d", "6"], " ", 
          SuperscriptBox["\[Pi]", "5"], " ", 
          SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}], "-", 
         RowBox[{"768", " ", 
          SuperscriptBox["d", "4"], " ", 
          SuperscriptBox["l", "3"], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
          SuperscriptBox["\[Sigma]", "3"]}], "-", 
         RowBox[{"384", " ", 
          SuperscriptBox["d", "5"], " ", 
          SuperscriptBox["l", "2"], " ", 
          SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
          SuperscriptBox["\[Sigma]", "3"]}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["d", "6"], " ", "l", " ", 
          SuperscriptBox["\[Pi]", "4"], " ", "\[CapitalDelta]G", " ", 
          SuperscriptBox["\[Sigma]", "3"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["d", "7"], " ", 
          SuperscriptBox["\[Pi]", "5"], " ", "\[CapitalDelta]G", " ", 
          SuperscriptBox["\[Sigma]", "3"]}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["d", "6"], " ", 
          SuperscriptBox["l", "2"], " ", 
          SuperscriptBox["\[Pi]", "3"], " ", 
          SuperscriptBox["\[Sigma]", "4"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["d", "7"], " ", "l", " ", 
          SuperscriptBox["\[Pi]", "4"], " ", 
          SuperscriptBox["\[Sigma]", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["d", "8"], " ", 
          SuperscriptBox["\[Pi]", "5"], " ", 
          SuperscriptBox["\[Sigma]", "4"]}]}], ")"}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.923012446160512*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"b44f965c-5699-4469-8de0-c2eb803941fd"],

Cell[BoxData[
 RowBox[{"\[CapitalDelta]G1", "\[Equal]", 
  RowBox[{"\[Sigma]", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       FractionBox["1", "d1"], "+", 
       FractionBox[
        RowBox[{"4", " ", "l"}], 
        RowBox[{
         SuperscriptBox["d1", "2"], " ", "\[Pi]"}]]}]], "-", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", " ", "l"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"\[Pi]", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["d1", "2"], "-", 
             RowBox[{
              FractionBox["1", 
               RowBox[{"2", " ", "\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "l"}], "+", 
                   RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                SuperscriptBox["\[Sigma]", "2"]}]], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "16"}], " ", 
                 SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                 SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                RowBox[{"8", " ", "d", " ", "l", " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", 
                 SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                RowBox[{
                 SuperscriptBox["d", "2"], " ", 
                 SuperscriptBox["\[Pi]", "3"], " ", 
                 SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
                RowBox[{"128", " ", 
                 SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", 
                 "\[Sigma]"}], "+", 
                RowBox[{"64", " ", "d", " ", 
                 SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                 "\[CapitalDelta]G", " ", "\[Sigma]"}], "+", 
                RowBox[{"16", " ", 
                 SuperscriptBox["d", "2"], " ", "l", " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
                 "\[Sigma]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["d", "3"], " ", 
                 SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
                 "\[Sigma]"}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["d", "3"], " ", "l", " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", 
                 SuperscriptBox["\[Sigma]", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["d", "4"], " ", 
                 SuperscriptBox["\[Pi]", "3"], " ", 
                 SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "+", 
             RowBox[{
              FractionBox["1", 
               RowBox[{"2", " ", 
                SqrtBox["\[Pi]"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "l"}], "+", 
                   RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                SuperscriptBox["\[Sigma]", "2"]}]], 
              RowBox[{"(", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"256", " ", 
                   SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{"256", " ", "d", " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["d", "2"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["d", "3"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{
                   SuperscriptBox["d", "4"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "-", 
                  RowBox[{"4096", " ", 
                   SuperscriptBox["l", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"4096", " ", "d", " ", 
                   SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"1792", " ", 
                   SuperscriptBox["d", "2"], " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"448", " ", 
                   SuperscriptBox["d", "3"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"64", " ", 
                   SuperscriptBox["d", "4"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["d", "5"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "+", 
                  RowBox[{"3072", " ", 
                   SuperscriptBox["d", "2"], " ", 
                   SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"2304", " ", 
                   SuperscriptBox["d", "3"], " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"672", " ", 
                   SuperscriptBox["d", "4"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["d", "5"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["d", "6"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "-", 
                  RowBox[{"768", " ", 
                   SuperscriptBox["d", "4"], " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "-", 
                  RowBox[{"384", " ", 
                   SuperscriptBox["d", "5"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "-", 
                  RowBox[{"64", " ", 
                   SuperscriptBox["d", "6"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "-", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["d", "7"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "+", 
                  RowBox[{"64", " ", 
                   SuperscriptBox["d", "6"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[Sigma]", "4"]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["d", "7"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[Sigma]", "4"]}], "+", 
                  RowBox[{
                   SuperscriptBox["d", "8"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[Sigma]", "4"]}]}], ")"}]}], ")"}]}]}], 
            ")"}]}], ")"}]}], "+", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"\[Sqrt]", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["d1", "2"], "-", 
             RowBox[{
              FractionBox["1", 
               RowBox[{"2", " ", "\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "l"}], "+", 
                   RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                SuperscriptBox["\[Sigma]", "2"]}]], 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "16"}], " ", 
                 SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                 SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                RowBox[{"8", " ", "d", " ", "l", " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", 
                 SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
                RowBox[{
                 SuperscriptBox["d", "2"], " ", 
                 SuperscriptBox["\[Pi]", "3"], " ", 
                 SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
                RowBox[{"128", " ", 
                 SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", 
                 "\[Sigma]"}], "+", 
                RowBox[{"64", " ", "d", " ", 
                 SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
                 "\[CapitalDelta]G", " ", "\[Sigma]"}], "+", 
                RowBox[{"16", " ", 
                 SuperscriptBox["d", "2"], " ", "l", " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
                 "\[Sigma]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["d", "3"], " ", 
                 SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
                 "\[Sigma]"}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["d", "3"], " ", "l", " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", 
                 SuperscriptBox["\[Sigma]", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["d", "4"], " ", 
                 SuperscriptBox["\[Pi]", "3"], " ", 
                 SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "+", 
             RowBox[{
              FractionBox["1", 
               RowBox[{"2", " ", 
                SqrtBox["\[Pi]"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "l"}], "+", 
                   RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
                SuperscriptBox["\[Sigma]", "2"]}]], 
              RowBox[{"(", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"256", " ", 
                   SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{"256", " ", "d", " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["d", "2"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["d", "3"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "+", 
                  RowBox[{
                   SuperscriptBox["d", "4"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "4"]}], "-", 
                  RowBox[{"4096", " ", 
                   SuperscriptBox["l", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"4096", " ", "d", " ", 
                   SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"1792", " ", 
                   SuperscriptBox["d", "2"], " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"448", " ", 
                   SuperscriptBox["d", "3"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"64", " ", 
                   SuperscriptBox["d", "4"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "-", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["d", "5"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "3"], " ", "\[Sigma]"}],
                   "+", 
                  RowBox[{"3072", " ", 
                   SuperscriptBox["d", "2"], " ", 
                   SuperscriptBox["l", "4"], " ", "\[Pi]", " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"2304", " ", 
                   SuperscriptBox["d", "3"], " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"672", " ", 
                   SuperscriptBox["d", "4"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"96", " ", 
                   SuperscriptBox["d", "5"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["d", "6"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[CapitalDelta]G", "2"], " ", 
                   SuperscriptBox["\[Sigma]", "2"]}], "-", 
                  RowBox[{"768", " ", 
                   SuperscriptBox["d", "4"], " ", 
                   SuperscriptBox["l", "3"], " ", 
                   SuperscriptBox["\[Pi]", "2"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "-", 
                  RowBox[{"384", " ", 
                   SuperscriptBox["d", "5"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "-", 
                  RowBox[{"64", " ", 
                   SuperscriptBox["d", "6"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "-", 
                  RowBox[{"4", " ", 
                   SuperscriptBox["d", "7"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", "\[CapitalDelta]G", " ", 
                   SuperscriptBox["\[Sigma]", "3"]}], "+", 
                  RowBox[{"64", " ", 
                   SuperscriptBox["d", "6"], " ", 
                   SuperscriptBox["l", "2"], " ", 
                   SuperscriptBox["\[Pi]", "3"], " ", 
                   SuperscriptBox["\[Sigma]", "4"]}], "+", 
                  RowBox[{"16", " ", 
                   SuperscriptBox["d", "7"], " ", "l", " ", 
                   SuperscriptBox["\[Pi]", "4"], " ", 
                   SuperscriptBox["\[Sigma]", "4"]}], "+", 
                  RowBox[{
                   SuperscriptBox["d", "8"], " ", 
                   SuperscriptBox["\[Pi]", "5"], " ", 
                   SuperscriptBox["\[Sigma]", "4"]}]}], ")"}]}], ")"}]}]}], 
            ")"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9230124461648397`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"50fb4bd3-d78d-4915-8479-045b33a2a56f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Simplify", " ", "the", " ", "above", " ", "considering", " ", 
    "\[CapitalDelta]G1", " ", "to", " ", "be", " ", "Real"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Simplify", "[", 
   RowBox[{"%4", ",", "Reals"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9230124526093197`*^9, 3.923012475158327*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"e523afa1-7980-4231-a5e5-a9df4ed9f63c"],

Cell[BoxData[
 RowBox[{"\[CapitalDelta]G1", "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["d1", "2"], " ", "\[Pi]", " ", "\[Sigma]"}], 
    RowBox[{
     RowBox[{"4", " ", "l"}], "+", 
     RowBox[{"d1", " ", "\[Pi]"}]}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["d", "2"]}], " ", 
       SuperscriptBox["\[Pi]", "3"], " ", 
       SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
      RowBox[{"128", " ", 
       SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", "\[Sigma]"}], 
      "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["d", "3"], " ", 
       SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
       "\[Sigma]"}], "+", 
      RowBox[{
       SuperscriptBox["d", "4"], " ", 
       SuperscriptBox["\[Pi]", "3"], " ", 
       SuperscriptBox["\[Sigma]", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["d1", "2"], " ", 
       SuperscriptBox["\[Pi]", "3"], " ", 
       SuperscriptBox["\[Sigma]", "2"]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[CapitalDelta]G", "2"], "-", 
         RowBox[{"4", " ", "d", " ", "\[CapitalDelta]G", " ", "\[Sigma]"}], 
         "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["d1", "2"], " ", 
          SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"8", " ", "d", " ", "l", " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
         RowBox[{"2", " ", "d", " ", "\[CapitalDelta]G", " ", "\[Sigma]"}], 
         "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["d", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["d1", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SqrtBox["\[Pi]"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "l", " ", "\[CapitalDelta]G"}], "+", 
            RowBox[{"d", " ", "\[Pi]", " ", 
             RowBox[{"(", 
              RowBox[{"\[CapitalDelta]G", "-", 
               RowBox[{"d", " ", "\[Sigma]"}]}], ")"}]}]}], ")"}], "3"], " ", 
         
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "64"}], " ", 
            SuperscriptBox["l", "2"], " ", "\[Sigma]"}], "+", 
           RowBox[{"4", " ", "l", " ", "\[Pi]", " ", 
            RowBox[{"(", 
             RowBox[{"\[CapitalDelta]G", "-", 
              RowBox[{"4", " ", "d", " ", "\[Sigma]"}]}], ")"}]}], "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["\[Pi]", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"\[CapitalDelta]G", "-", 
              RowBox[{"d", " ", "\[Sigma]"}]}], ")"}]}]}], ")"}]}]]}]}], 
     ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "l"}], "+", 
         RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", "\[Sigma]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", "l"}], "+", 
        RowBox[{
         SqrtBox[
          RowBox[{"2", " ", "\[Pi]"}]], " ", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "l"}], "+", 
                 RowBox[{"d", " ", "\[Pi]"}]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Sigma]", "2"]}]], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["d", "2"], " ", 
               SuperscriptBox["\[Pi]", "3"], " ", 
               SuperscriptBox["\[CapitalDelta]G", "2"]}], "-", 
              RowBox[{"128", " ", 
               SuperscriptBox["l", "3"], " ", "\[CapitalDelta]G", " ", 
               "\[Sigma]"}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["d", "3"], " ", 
               SuperscriptBox["\[Pi]", "3"], " ", "\[CapitalDelta]G", " ", 
               "\[Sigma]"}], "-", 
              RowBox[{
               SuperscriptBox["d", "4"], " ", 
               SuperscriptBox["\[Pi]", "3"], " ", 
               SuperscriptBox["\[Sigma]", "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["d", "2"], " ", 
               SuperscriptBox["d1", "2"], " ", 
               SuperscriptBox["\[Pi]", "3"], " ", 
               SuperscriptBox["\[Sigma]", "2"]}], "+", 
              RowBox[{"16", " ", 
               SuperscriptBox["l", "2"], " ", "\[Pi]", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["\[CapitalDelta]G", "2"], "-", 
                 RowBox[{
                 "4", " ", "d", " ", "\[CapitalDelta]G", " ", "\[Sigma]"}], 
                 "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["d1", "2"], " ", 
                  SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "-", 
              RowBox[{"8", " ", "d", " ", "l", " ", 
               SuperscriptBox["\[Pi]", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["\[CapitalDelta]G", "2"]}], "+", 
                 RowBox[{
                 "2", " ", "d", " ", "\[CapitalDelta]G", " ", "\[Sigma]"}], 
                 "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["d", "2"], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["d1", "2"]}]}], ")"}], " ", 
                  SuperscriptBox["\[Sigma]", "2"]}]}], ")"}]}], "+", 
              RowBox[{
               SqrtBox["\[Pi]"], " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "l", " ", "\[CapitalDelta]G"}], "+", 
                    RowBox[{"d", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[CapitalDelta]G", "-", 
                    RowBox[{"d", " ", "\[Sigma]"}]}], ")"}]}]}], ")"}], "3"], 
                 " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "64"}], " ", 
                    SuperscriptBox["l", "2"], " ", "\[Sigma]"}], "+", 
                   RowBox[{"4", " ", "l", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[CapitalDelta]G", "-", 
                    RowBox[{"4", " ", "d", " ", "\[Sigma]"}]}], ")"}]}], "+", 
                   
                   RowBox[{"d", " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"\[CapitalDelta]G", "-", 
                    RowBox[{"d", " ", "\[Sigma]"}]}], ")"}]}]}], ")"}]}]]}]}],
              ")"}]}], ")"}]}]}]}], ")"}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.923012486575591*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"c5b16bc9-2818-41d3-aa2c-1cf89c3bcdaf"]
}, Open  ]]
},
WindowSize->{864, 1051},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
FrontEndVersion->"14.0 for Mac OS X ARM (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"102530a2-92fe-4c0c-a15e-7161b6ba19c3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 1987, 55, 178, "Input",ExpressionUUID->"828ac962-c356-4a6c-a4ce-ae15297319ef"],
Cell[2570, 79, 18929, 379, 506, "Output",ExpressionUUID->"20ee5218-4a7a-4301-94bd-6e9e9982248d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21536, 463, 9695, 228, 460, "Input",ExpressionUUID->"e958bfd6-1af1-4d74-a9e9-06545e84d108"],
Cell[31234, 693, 7054, 166, 214, "Output",ExpressionUUID->"b44f965c-5699-4469-8de0-c2eb803941fd"],
Cell[38291, 861, 17821, 364, 519, "Output",ExpressionUUID->"50fb4bd3-d78d-4915-8479-045b33a2a56f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56149, 1230, 442, 10, 52, "Input",ExpressionUUID->"e523afa1-7980-4231-a5e5-a9df4ed9f63c"],
Cell[56594, 1242, 7410, 189, 251, "Output",ExpressionUUID->"c5b16bc9-2818-41d3-aa2c-1cf89c3bcdaf"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

